/*****************************************************************
** Ȩ:   Ƽ޹˾
** ļ:Segment_Lcd.c
** 汾V1.0
** :IAR Embedded Workbench Evaluation for MSP430 4.10A
** :Huanglongsong
** ѭI2CЭ鶨غ
** :200811
*****************************************************************/
#include "msp430afe253.h"
#include "General_File.h"
#include "Segment_LCD.h"
#include "I2C_Define.h"
#include "LCD.h"

/************            BU9796FSָ          **********/
#define     Write_Com            0x80
#define     Write_Data           0x00
#define     Display_ON           0x48          // 1/3 bias
#define     Display_OFF          0x40
#define     Half_Bias            0x44
#define     Set_Reset            0x6A
#define     Ext_Clock            0x69
#define     Blink_Mode0          0x70
#define     Blink_Mode1          0x71
#define     Blink_Mode2          0x72
#define     Blink_Mode3          0x73
#define     Pixel_ON             0x7E
#define     Pixel_OFF            0x7D
#define     BU9796_Addr          0x7C
#define     Base_Add             0x00

/*****************************************************************
** Segment_Display                                                  
** ܣʽLCDݰд򣬸һַ͵ʽLCDȥʾ
** : Huanglongsong
** : 2008.11
** ļ:
** ޸־
****************************************************************/ 
void Segment_Display( const uchar Addr,const uchar *P_Data, uchar Length )
{
    uchar i;
    uchar User_Addr = Addr;
    
    I2C_Start();                                 //BU9796 
    I2C_Senduchar( BU9796_Addr );                //дBU9796ַ
    I2C_Write_ACK();
    I2C_Senduchar( Base_Add + User_Addr * 2 );   //ʼַһ
    I2C_Write_ACK();
    for(  i=0  ;i < Length;i++ )
    {
        I2C_Senduchar(*P_Data++); 
        I2C_Write_ACK();
    }
    I2C_Stop();                                  //ʽ
} 
/*****************************************************************
** Init_BU9796FS                                                     
** ܣʼоƬBU9796ز
** : Huanglongsong
** : 2008.11
** ļ:
** ޸־
*****************************************************************/
void Init_BU9796FS( void )
{
    I2C_Start();                             //BU9796   
    I2C_Senduchar( BU9796_Addr );            //дBU9796ַ
    I2C_Write_ACK();                         //ȴack 
    I2C_Senduchar( Write_Com + Set_Reset);   //λ
    I2C_Write_ACK();                         //ȴack
//    I2C_Senduchar( Write_Com + Blink_Mode2 ); //Һ˸
//    I2C_Write_ACK();
    I2C_Senduchar( Write_Com + Display_ON ); //ʾ
    I2C_Write_ACK();
    I2C_Senduchar( Write_Data + Base_Add );  //ʼַһ
    I2C_Write_ACK();
    for( uchar i = 0;i<10;i++ )              //LCDʾ
    {
       I2C_Senduchar( 0x00 );
       I2C_Write_ACK();
    }
    I2C_Stop();                              //ʽ
}
/*****************************************************************
** Init_MCU                                                    
** ܣʼMSP430ز
** : Huanglongsong
** : 2008.11
** ļ:
** ޸־
*****************************************************************/
void Init_MCU( void )
{
    WDTCTL = WDTPW + WDTHOLD;                  // ؿŹ
    BCSCTL3 |= XT2S_2;                         // XT2ƵʷΧ
    BCSCTL1 &= ~XT2OFF;                        // XT2
    do
    {
        IFG1 &= ~OFIFG;                       // ʧЧ־
        BCSCTL3 &= ~XT2OF;                    // XT2ʧЧ־
        for( uint i = 0x47FF; i > 0; i-- );   // ȴXT2Ƶȶ
    }while (IFG1 & OFIFG);                    // ⲿʱԴ
    BCSCTL2 |= SELM_2 + SELS ;                // MCLKSMCLKΪXT2 
//    P4OUT &= ~BIT4;
//    P4DIR |=  BIT4;                           // LCDʾֵĵԴ
    //P8REN |= BIT3 + BIT4;
//    P8DIR |= BIT3 + BIT4;                     // MSP430BU9796
//    P8OUT |= BIT3 + BIT4;
    DIR_SCL_OUT;                               // SDA SCLø
    SCL_1;
    DIR_OUT;
    SDA_1;
//    P5OUT &= ~BIT7;                           // ⲿLED
//    P5DIR |= BIT7;
}
/*****************************************************************
** main                                                   
** ܣϵͳ
** : Huanglongsong
** : 2008.11
** ļ:
** ޸־
******************************************************************/
/*
void main( void )
{
    Init_MCU();
    Init_BU9796FS();
    P5OUT |= BIT7;
    Segment_Display( 0,Disp_Data,6 );
    _BIS_SR( CPUOFF ); 
}
*/

